// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ChangeAnalysis.Models
{
    /// <summary> The type of the change. </summary>
    public readonly partial struct ChangeType : IEquatable<ChangeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChangeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChangeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddValue = "Add";
        private const string RemoveValue = "Remove";
        private const string UpdateValue = "Update";

        /// <summary> Add. </summary>
        public static ChangeType Add { get; } = new ChangeType(AddValue);
        /// <summary> Remove. </summary>
        public static ChangeType Remove { get; } = new ChangeType(RemoveValue);
        /// <summary> Update. </summary>
        public static ChangeType Update { get; } = new ChangeType(UpdateValue);
        /// <summary> Determines if two <see cref="ChangeType"/> values are the same. </summary>
        public static bool operator ==(ChangeType left, ChangeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChangeType"/> values are not the same. </summary>
        public static bool operator !=(ChangeType left, ChangeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChangeType"/>. </summary>
        public static implicit operator ChangeType(string value) => new ChangeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChangeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChangeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
