// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.ChangeAnalysis.Models
{
    /// <summary> The properties of a change. </summary>
    public partial class ChangeProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ChangeProperties"/>. </summary>
        internal ChangeProperties()
        {
            InitiatedByList = new ChangeTrackingList<string>();
            PropertyChanges = new ChangeTrackingList<PropertyChange>();
        }

        /// <summary> Initializes a new instance of <see cref="ChangeProperties"/>. </summary>
        /// <param name="resourceId"> The resource id that the change is attached to. </param>
        /// <param name="changeDetectedOn"> The time when the change is detected. </param>
        /// <param name="initiatedByList">
        /// The list of identities who might initiated the change.
        /// The identity could be user name (email address) or the object ID of the Service Principal.
        /// </param>
        /// <param name="changeType"> The type of the change. </param>
        /// <param name="propertyChanges"> The list of detailed changes at json property level. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChangeProperties(ResourceIdentifier resourceId, DateTimeOffset? changeDetectedOn, IReadOnlyList<string> initiatedByList, ChangeType? changeType, IReadOnlyList<PropertyChange> propertyChanges, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceId = resourceId;
            ChangeDetectedOn = changeDetectedOn;
            InitiatedByList = initiatedByList;
            ChangeType = changeType;
            PropertyChanges = propertyChanges;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource id that the change is attached to. </summary>
        public ResourceIdentifier ResourceId { get; }
        /// <summary> The time when the change is detected. </summary>
        public DateTimeOffset? ChangeDetectedOn { get; }
        /// <summary>
        /// The list of identities who might initiated the change.
        /// The identity could be user name (email address) or the object ID of the Service Principal.
        /// </summary>
        public IReadOnlyList<string> InitiatedByList { get; }
        /// <summary> The type of the change. </summary>
        public ChangeType? ChangeType { get; }
        /// <summary> The list of detailed changes at json property level. </summary>
        public IReadOnlyList<PropertyChange> PropertyChanges { get; }
    }
}
