// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.ChangeAnalysis.Models
{
    internal static partial class ChangeCategoryExtensions
    {
        public static string ToSerialString(this ChangeCategory value) => value switch
        {
            ChangeCategory.User => "User",
            ChangeCategory.System => "System",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ChangeCategory value.")
        };

        public static ChangeCategory ToChangeCategory(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "User")) return ChangeCategory.User;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "System")) return ChangeCategory.System;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ChangeCategory value.");
        }
    }
}
