// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ChangeAnalysis.Models;

namespace Azure.ResourceManager.ChangeAnalysis.Mocking
{
    /// <summary> A class to add extension methods to TenantResource. </summary>
    public partial class MockableChangeAnalysisTenantResource : ArmResource
    {
        private ClientDiagnostics _resourceChangesClientDiagnostics;
        private ResourceChangesRestOperations _resourceChangesRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableChangeAnalysisTenantResource"/> class for mocking. </summary>
        protected MockableChangeAnalysisTenantResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableChangeAnalysisTenantResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableChangeAnalysisTenantResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics ResourceChangesClientDiagnostics => _resourceChangesClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.ChangeAnalysis", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private ResourceChangesRestOperations ResourceChangesRestClient => _resourceChangesRestClient ??= new ResourceChangesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// List the changes of a resource within the specified time range. Customer data will be masked if the user doesn't have access.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.ChangeAnalysis/resourceChanges</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ResourceChanges_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceId"> The identifier of the resource. </param>
        /// <param name="startTime"> Specifies the start time of the changes request. </param>
        /// <param name="endTime"> Specifies the end time of the changes request. </param>
        /// <param name="skipToken"> A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies a starting point to use for subsequent calls. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="resourceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        /// <returns> An async collection of <see cref="DetectedChangeData"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DetectedChangeData> GetResourceChangesAsync(string resourceId, DateTimeOffset startTime, DateTimeOffset endTime, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(resourceId, nameof(resourceId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => ResourceChangesRestClient.CreateListRequest(resourceId, startTime, endTime, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => ResourceChangesRestClient.CreateListNextPageRequest(nextLink, resourceId, startTime, endTime, skipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => DetectedChangeData.DeserializeDetectedChangeData(e), ResourceChangesClientDiagnostics, Pipeline, "MockableChangeAnalysisTenantResource.GetResourceChanges", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List the changes of a resource within the specified time range. Customer data will be masked if the user doesn't have access.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.ChangeAnalysis/resourceChanges</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ResourceChanges_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceId"> The identifier of the resource. </param>
        /// <param name="startTime"> Specifies the start time of the changes request. </param>
        /// <param name="endTime"> Specifies the end time of the changes request. </param>
        /// <param name="skipToken"> A skip token is used to continue retrieving items after an operation returns a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies a starting point to use for subsequent calls. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="resourceId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> is null. </exception>
        /// <returns> A collection of <see cref="DetectedChangeData"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DetectedChangeData> GetResourceChanges(string resourceId, DateTimeOffset startTime, DateTimeOffset endTime, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(resourceId, nameof(resourceId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => ResourceChangesRestClient.CreateListRequest(resourceId, startTime, endTime, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => ResourceChangesRestClient.CreateListNextPageRequest(nextLink, resourceId, startTime, endTime, skipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => DetectedChangeData.DeserializeDetectedChangeData(e), ResourceChangesClientDiagnostics, Pipeline, "MockableChangeAnalysisTenantResource.GetResourceChanges", "value", "nextLink", cancellationToken);
        }
    }
}
