// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Provisioning state of the WebApplicationFirewallPolicy. </summary>
    public readonly partial struct WebApplicationFirewallPolicyProvisioningState : IEquatable<WebApplicationFirewallPolicyProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WebApplicationFirewallPolicyProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WebApplicationFirewallPolicyProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static WebApplicationFirewallPolicyProvisioningState Creating { get; } = new WebApplicationFirewallPolicyProvisioningState(CreatingValue);
        /// <summary> Succeeded. </summary>
        public static WebApplicationFirewallPolicyProvisioningState Succeeded { get; } = new WebApplicationFirewallPolicyProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static WebApplicationFirewallPolicyProvisioningState Failed { get; } = new WebApplicationFirewallPolicyProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="WebApplicationFirewallPolicyProvisioningState"/> values are the same. </summary>
        public static bool operator ==(WebApplicationFirewallPolicyProvisioningState left, WebApplicationFirewallPolicyProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WebApplicationFirewallPolicyProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(WebApplicationFirewallPolicyProvisioningState left, WebApplicationFirewallPolicyProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WebApplicationFirewallPolicyProvisioningState"/>. </summary>
        public static implicit operator WebApplicationFirewallPolicyProvisioningState(string value) => new WebApplicationFirewallPolicyProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WebApplicationFirewallPolicyProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WebApplicationFirewallPolicyProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
