// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The WafRankingType. </summary>
    public readonly partial struct WafRankingType : IEquatable<WafRankingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WafRankingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WafRankingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActionValue = "action";
        private const string RuleGroupValue = "ruleGroup";
        private const string RuleIdValue = "ruleId";
        private const string UserAgentValue = "userAgent";
        private const string ClientIPValue = "clientIp";
        private const string UriValue = "url";
        private const string CountryOrRegionValue = "countryOrRegion";
        private const string RuleTypeValue = "ruleType";

        /// <summary> action. </summary>
        public static WafRankingType Action { get; } = new WafRankingType(ActionValue);
        /// <summary> ruleGroup. </summary>
        public static WafRankingType RuleGroup { get; } = new WafRankingType(RuleGroupValue);
        /// <summary> ruleId. </summary>
        public static WafRankingType RuleId { get; } = new WafRankingType(RuleIdValue);
        /// <summary> userAgent. </summary>
        public static WafRankingType UserAgent { get; } = new WafRankingType(UserAgentValue);
        /// <summary> clientIp. </summary>
        public static WafRankingType ClientIP { get; } = new WafRankingType(ClientIPValue);
        /// <summary> url. </summary>
        public static WafRankingType Uri { get; } = new WafRankingType(UriValue);
        /// <summary> countryOrRegion. </summary>
        public static WafRankingType CountryOrRegion { get; } = new WafRankingType(CountryOrRegionValue);
        /// <summary> ruleType. </summary>
        public static WafRankingType RuleType { get; } = new WafRankingType(RuleTypeValue);
        /// <summary> Determines if two <see cref="WafRankingType"/> values are the same. </summary>
        public static bool operator ==(WafRankingType left, WafRankingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WafRankingType"/> values are not the same. </summary>
        public static bool operator !=(WafRankingType left, WafRankingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WafRankingType"/>. </summary>
        public static implicit operator WafRankingType(string value) => new WafRankingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WafRankingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WafRankingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
