// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The WafRankingGroupBy. </summary>
    public readonly partial struct WafRankingGroupBy : IEquatable<WafRankingGroupBy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WafRankingGroupBy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WafRankingGroupBy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpStatusCodeValue = "httpStatusCode";
        private const string CustomDomainValue = "customDomain";

        /// <summary> httpStatusCode. </summary>
        public static WafRankingGroupBy HttpStatusCode { get; } = new WafRankingGroupBy(HttpStatusCodeValue);
        /// <summary> customDomain. </summary>
        public static WafRankingGroupBy CustomDomain { get; } = new WafRankingGroupBy(CustomDomainValue);
        /// <summary> Determines if two <see cref="WafRankingGroupBy"/> values are the same. </summary>
        public static bool operator ==(WafRankingGroupBy left, WafRankingGroupBy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WafRankingGroupBy"/> values are not the same. </summary>
        public static bool operator !=(WafRankingGroupBy left, WafRankingGroupBy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WafRankingGroupBy"/>. </summary>
        public static implicit operator WafRankingGroupBy(string value) => new WafRankingGroupBy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WafRankingGroupBy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WafRankingGroupBy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
