// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines a managed rule set. </summary>
    public partial class WafPolicyManagedRuleSet
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WafPolicyManagedRuleSet"/>. </summary>
        /// <param name="ruleSetType"> Defines the rule set type to use. </param>
        /// <param name="ruleSetVersion"> Defines the version of the rule set to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleSetType"/> or <paramref name="ruleSetVersion"/> is null. </exception>
        public WafPolicyManagedRuleSet(string ruleSetType, string ruleSetVersion)
        {
            Argument.AssertNotNull(ruleSetType, nameof(ruleSetType));
            Argument.AssertNotNull(ruleSetVersion, nameof(ruleSetVersion));

            RuleSetType = ruleSetType;
            RuleSetVersion = ruleSetVersion;
            RuleGroupOverrides = new ChangeTrackingList<ManagedRuleGroupOverrideSetting>();
        }

        /// <summary> Initializes a new instance of <see cref="WafPolicyManagedRuleSet"/>. </summary>
        /// <param name="ruleSetType"> Defines the rule set type to use. </param>
        /// <param name="ruleSetVersion"> Defines the version of the rule set to use. </param>
        /// <param name="anomalyScore"> Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests. </param>
        /// <param name="ruleGroupOverrides"> Defines the rule overrides to apply to the rule set. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WafPolicyManagedRuleSet(string ruleSetType, string ruleSetVersion, int? anomalyScore, IList<ManagedRuleGroupOverrideSetting> ruleGroupOverrides, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleSetType = ruleSetType;
            RuleSetVersion = ruleSetVersion;
            AnomalyScore = anomalyScore;
            RuleGroupOverrides = ruleGroupOverrides;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="WafPolicyManagedRuleSet"/> for deserialization. </summary>
        internal WafPolicyManagedRuleSet()
        {
        }

        /// <summary> Defines the rule set type to use. </summary>
        public string RuleSetType { get; set; }
        /// <summary> Defines the version of the rule set to use. </summary>
        public string RuleSetVersion { get; set; }
        /// <summary> Verizon only : If the rule set supports anomaly detection mode, this describes the threshold for blocking requests. </summary>
        public int? AnomalyScore { get; set; }
        /// <summary> Defines the rule overrides to apply to the rule set. </summary>
        public IList<ManagedRuleGroupOverrideSetting> RuleGroupOverrides { get; }
    }
}
