// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The WafMetricsResponseSeriesItemUnit. </summary>
    public readonly partial struct WafMetricsResponseSeriesItemUnit : IEquatable<WafMetricsResponseSeriesItemUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WafMetricsResponseSeriesItemUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WafMetricsResponseSeriesItemUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "count";

        /// <summary> count. </summary>
        public static WafMetricsResponseSeriesItemUnit Count { get; } = new WafMetricsResponseSeriesItemUnit(CountValue);
        /// <summary> Determines if two <see cref="WafMetricsResponseSeriesItemUnit"/> values are the same. </summary>
        public static bool operator ==(WafMetricsResponseSeriesItemUnit left, WafMetricsResponseSeriesItemUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WafMetricsResponseSeriesItemUnit"/> values are not the same. </summary>
        public static bool operator !=(WafMetricsResponseSeriesItemUnit left, WafMetricsResponseSeriesItemUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WafMetricsResponseSeriesItemUnit"/>. </summary>
        public static implicit operator WafMetricsResponseSeriesItemUnit(string value) => new WafMetricsResponseSeriesItemUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WafMetricsResponseSeriesItemUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WafMetricsResponseSeriesItemUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
