// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The WafMetricsResponseGranularity. </summary>
    public readonly partial struct WafMetricsResponseGranularity : IEquatable<WafMetricsResponseGranularity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WafMetricsResponseGranularity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WafMetricsResponseGranularity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PT5MValue = "PT5M";
        private const string PT1HValue = "PT1H";
        private const string P1DValue = "P1D";

        /// <summary> PT5M. </summary>
        public static WafMetricsResponseGranularity PT5M { get; } = new WafMetricsResponseGranularity(PT5MValue);
        /// <summary> PT1H. </summary>
        public static WafMetricsResponseGranularity PT1H { get; } = new WafMetricsResponseGranularity(PT1HValue);
        /// <summary> P1D. </summary>
        public static WafMetricsResponseGranularity P1D { get; } = new WafMetricsResponseGranularity(P1DValue);
        /// <summary> Determines if two <see cref="WafMetricsResponseGranularity"/> values are the same. </summary>
        public static bool operator ==(WafMetricsResponseGranularity left, WafMetricsResponseGranularity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WafMetricsResponseGranularity"/> values are not the same. </summary>
        public static bool operator !=(WafMetricsResponseGranularity left, WafMetricsResponseGranularity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WafMetricsResponseGranularity"/>. </summary>
        public static implicit operator WafMetricsResponseGranularity(string value) => new WafMetricsResponseGranularity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WafMetricsResponseGranularity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WafMetricsResponseGranularity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
