// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The WafMetric. </summary>
    public readonly partial struct WafMetric : IEquatable<WafMetric>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WafMetric"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WafMetric(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClientRequestCountValue = "clientRequestCount";

        /// <summary> clientRequestCount. </summary>
        public static WafMetric ClientRequestCount { get; } = new WafMetric(ClientRequestCountValue);
        /// <summary> Determines if two <see cref="WafMetric"/> values are the same. </summary>
        public static bool operator ==(WafMetric left, WafMetric right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WafMetric"/> values are not the same. </summary>
        public static bool operator !=(WafMetric left, WafMetric right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WafMetric"/>. </summary>
        public static implicit operator WafMetric(string value) => new WafMetric(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WafMetric other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WafMetric other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
