// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Match variable to compare against. </summary>
    public readonly partial struct WafMatchVariable : IEquatable<WafMatchVariable>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WafMatchVariable"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WafMatchVariable(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RemoteAddrValue = "RemoteAddr";
        private const string SocketAddrValue = "SocketAddr";
        private const string RequestMethodValue = "RequestMethod";
        private const string RequestHeaderValue = "RequestHeader";
        private const string RequestUriValue = "RequestUri";
        private const string QueryStringValue = "QueryString";
        private const string RequestBodyValue = "RequestBody";
        private const string CookiesValue = "Cookies";
        private const string PostArgsValue = "PostArgs";

        /// <summary> RemoteAddr. </summary>
        public static WafMatchVariable RemoteAddr { get; } = new WafMatchVariable(RemoteAddrValue);
        /// <summary> SocketAddr. </summary>
        public static WafMatchVariable SocketAddr { get; } = new WafMatchVariable(SocketAddrValue);
        /// <summary> RequestMethod. </summary>
        public static WafMatchVariable RequestMethod { get; } = new WafMatchVariable(RequestMethodValue);
        /// <summary> RequestHeader. </summary>
        public static WafMatchVariable RequestHeader { get; } = new WafMatchVariable(RequestHeaderValue);
        /// <summary> RequestUri. </summary>
        public static WafMatchVariable RequestUri { get; } = new WafMatchVariable(RequestUriValue);
        /// <summary> QueryString. </summary>
        public static WafMatchVariable QueryString { get; } = new WafMatchVariable(QueryStringValue);
        /// <summary> RequestBody. </summary>
        public static WafMatchVariable RequestBody { get; } = new WafMatchVariable(RequestBodyValue);
        /// <summary> Cookies. </summary>
        public static WafMatchVariable Cookies { get; } = new WafMatchVariable(CookiesValue);
        /// <summary> PostArgs. </summary>
        public static WafMatchVariable PostArgs { get; } = new WafMatchVariable(PostArgsValue);
        /// <summary> Determines if two <see cref="WafMatchVariable"/> values are the same. </summary>
        public static bool operator ==(WafMatchVariable left, WafMatchVariable right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WafMatchVariable"/> values are not the same. </summary>
        public static bool operator !=(WafMatchVariable left, WafMatchVariable right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WafMatchVariable"/>. </summary>
        public static implicit operator WafMatchVariable(string value) => new WafMatchVariable(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WafMatchVariable other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WafMatchVariable other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
