// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The WafAction. </summary>
    public readonly partial struct WafAction : IEquatable<WafAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WafAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WafAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "allow";
        private const string BlockValue = "block";
        private const string LogValue = "log";
        private const string RedirectValue = "redirect";

        /// <summary> allow. </summary>
        public static WafAction Allow { get; } = new WafAction(AllowValue);
        /// <summary> block. </summary>
        public static WafAction Block { get; } = new WafAction(BlockValue);
        /// <summary> log. </summary>
        public static WafAction Log { get; } = new WafAction(LogValue);
        /// <summary> redirect. </summary>
        public static WafAction Redirect { get; } = new WafAction(RedirectValue);
        /// <summary> Determines if two <see cref="WafAction"/> values are the same. </summary>
        public static bool operator ==(WafAction left, WafAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WafAction"/> values are not the same. </summary>
        public static bool operator !=(WafAction left, WafAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WafAction"/>. </summary>
        public static implicit operator WafAction(string value) => new WafAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WafAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WafAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
