// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Input of the validate probe API. </summary>
    public partial class ValidateProbeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ValidateProbeContent"/>. </summary>
        /// <param name="probeUri"> The probe URL to validate. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="probeUri"/> is null. </exception>
        public ValidateProbeContent(Uri probeUri)
        {
            Argument.AssertNotNull(probeUri, nameof(probeUri));

            ProbeUri = probeUri;
        }

        /// <summary> Initializes a new instance of <see cref="ValidateProbeContent"/>. </summary>
        /// <param name="probeUri"> The probe URL to validate. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ValidateProbeContent(Uri probeUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProbeUri = probeUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ValidateProbeContent"/> for deserialization. </summary>
        internal ValidateProbeContent()
        {
        }

        /// <summary> The probe URL to validate. </summary>
        public Uri ProbeUri { get; }
    }
}
