// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines the certificate source parameters using user's keyvault certificate for enabling SSL. </summary>
    public partial class UserManagedHttpsContent : CustomDomainHttpsContent
    {
        /// <summary> Initializes a new instance of <see cref="UserManagedHttpsContent"/>. </summary>
        /// <param name="protocolType"> Defines the TLS extension protocol that is used for secure delivery. </param>
        /// <param name="certificateSourceParameters"> Defines the certificate source parameters using user's keyvault certificate for enabling SSL. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="certificateSourceParameters"/> is null. </exception>
        public UserManagedHttpsContent(SecureDeliveryProtocolType protocolType, KeyVaultCertificateSource certificateSourceParameters) : base(protocolType)
        {
            Argument.AssertNotNull(certificateSourceParameters, nameof(certificateSourceParameters));

            CertificateSourceParameters = certificateSourceParameters;
            CertificateSource = CertificateSource.AzureKeyVault;
        }

        /// <summary> Initializes a new instance of <see cref="UserManagedHttpsContent"/>. </summary>
        /// <param name="certificateSource"> Defines the source of the SSL certificate. </param>
        /// <param name="protocolType"> Defines the TLS extension protocol that is used for secure delivery. </param>
        /// <param name="minimumTlsVersion"> TLS protocol version that will be used for Https. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="certificateSourceParameters"> Defines the certificate source parameters using user's keyvault certificate for enabling SSL. </param>
        internal UserManagedHttpsContent(CertificateSource certificateSource, SecureDeliveryProtocolType protocolType, CdnMinimumTlsVersion? minimumTlsVersion, IDictionary<string, BinaryData> serializedAdditionalRawData, KeyVaultCertificateSource certificateSourceParameters) : base(certificateSource, protocolType, minimumTlsVersion, serializedAdditionalRawData)
        {
            CertificateSourceParameters = certificateSourceParameters;
            CertificateSource = certificateSource;
        }

        /// <summary> Initializes a new instance of <see cref="UserManagedHttpsContent"/> for deserialization. </summary>
        internal UserManagedHttpsContent()
        {
        }

        /// <summary> Defines the certificate source parameters using user's keyvault certificate for enabling SSL. </summary>
        public KeyVaultCertificateSource CertificateSourceParameters { get; set; }
    }
}
