// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines how to identify a parameter for a specific purpose e.g. expires. </summary>
    public partial class UriSigningParamIdentifier
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UriSigningParamIdentifier"/>. </summary>
        /// <param name="paramIndicator"> Indicates the purpose of the parameter. </param>
        /// <param name="paramName"> Parameter name. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="paramName"/> is null. </exception>
        public UriSigningParamIdentifier(ParamIndicator paramIndicator, string paramName)
        {
            Argument.AssertNotNull(paramName, nameof(paramName));

            ParamIndicator = paramIndicator;
            ParamName = paramName;
        }

        /// <summary> Initializes a new instance of <see cref="UriSigningParamIdentifier"/>. </summary>
        /// <param name="paramIndicator"> Indicates the purpose of the parameter. </param>
        /// <param name="paramName"> Parameter name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UriSigningParamIdentifier(ParamIndicator paramIndicator, string paramName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ParamIndicator = paramIndicator;
            ParamName = paramName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UriSigningParamIdentifier"/> for deserialization. </summary>
        internal UriSigningParamIdentifier()
        {
        }

        /// <summary> Indicates the purpose of the parameter. </summary>
        public ParamIndicator ParamIndicator { get; set; }
        /// <summary> Parameter name. </summary>
        public string ParamName { get; set; }
    }
}
