// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines the parameters for the url redirect action. </summary>
    public partial class UriRedirectActionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UriRedirectActionProperties"/>. </summary>
        /// <param name="actionType"></param>
        /// <param name="redirectType"> The redirect type the rule will use when redirecting traffic. </param>
        public UriRedirectActionProperties(UriRedirectActionType actionType, RedirectType redirectType)
        {
            ActionType = actionType;
            RedirectType = redirectType;
        }

        /// <summary> Initializes a new instance of <see cref="UriRedirectActionProperties"/>. </summary>
        /// <param name="actionType"></param>
        /// <param name="redirectType"> The redirect type the rule will use when redirecting traffic. </param>
        /// <param name="destinationProtocol"> Protocol to use for the redirect. The default value is MatchRequest. </param>
        /// <param name="customPath"> The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path. </param>
        /// <param name="customHostname"> Host to redirect. Leave empty to use the incoming host as the destination host. </param>
        /// <param name="customQueryString"> The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in &lt;key&gt;=&lt;value&gt; format. ? and &amp; will be added automatically so do not include them. </param>
        /// <param name="customFragment"> Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UriRedirectActionProperties(UriRedirectActionType actionType, RedirectType redirectType, DestinationProtocol? destinationProtocol, string customPath, string customHostname, string customQueryString, string customFragment, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActionType = actionType;
            RedirectType = redirectType;
            DestinationProtocol = destinationProtocol;
            CustomPath = customPath;
            CustomHostname = customHostname;
            CustomQueryString = customQueryString;
            CustomFragment = customFragment;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UriRedirectActionProperties"/> for deserialization. </summary>
        internal UriRedirectActionProperties()
        {
        }

        /// <summary> Gets or sets the action type. </summary>
        public UriRedirectActionType ActionType { get; set; }
        /// <summary> The redirect type the rule will use when redirecting traffic. </summary>
        public RedirectType RedirectType { get; set; }
        /// <summary> Protocol to use for the redirect. The default value is MatchRequest. </summary>
        public DestinationProtocol? DestinationProtocol { get; set; }
        /// <summary> The full path to redirect. Path cannot be empty and must start with /. Leave empty to use the incoming path as destination path. </summary>
        public string CustomPath { get; set; }
        /// <summary> Host to redirect. Leave empty to use the incoming host as the destination host. </summary>
        public string CustomHostname { get; set; }
        /// <summary> The set of query strings to be placed in the redirect URL. Setting this value would replace any existing query string; leave empty to preserve the incoming query string. Query string must be in &lt;key&gt;=&lt;value&gt; format. ? and &amp; will be added automatically so do not include them. </summary>
        public string CustomQueryString { get; set; }
        /// <summary> Fragment to add to the redirect URL. Fragment is the part of the URL that comes after #. Do not include the #. </summary>
        public string CustomFragment { get; set; }
    }
}
