// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Defines the url redirect action for the delivery rule. </summary>
    public partial class UriRedirectAction : DeliveryRuleAction
    {
        /// <summary> Initializes a new instance of <see cref="UriRedirectAction"/>. </summary>
        /// <param name="properties"> Defines the parameters for the action. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="properties"/> is null. </exception>
        public UriRedirectAction(UriRedirectActionProperties properties)
        {
            Argument.AssertNotNull(properties, nameof(properties));

            Properties = properties;
            Name = DeliveryRuleActionType.UriRedirect;
        }

        /// <summary> Initializes a new instance of <see cref="UriRedirectAction"/>. </summary>
        /// <param name="name"> The name of the action for the delivery rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> Defines the parameters for the action. </param>
        internal UriRedirectAction(DeliveryRuleActionType name, IDictionary<string, BinaryData> serializedAdditionalRawData, UriRedirectActionProperties properties) : base(name, serializedAdditionalRawData)
        {
            Properties = properties;
            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="UriRedirectAction"/> for deserialization. </summary>
        internal UriRedirectAction()
        {
        }

        /// <summary> Defines the parameters for the action. </summary>
        public UriRedirectActionProperties Properties { get; set; }
    }
}
