// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes operator to be matched. </summary>
    public readonly partial struct UriFileExtensionOperator : IEquatable<UriFileExtensionOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UriFileExtensionOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UriFileExtensionOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnyValue = "Any";
        private const string EqualValue = "Equal";
        private const string ContainsValue = "Contains";
        private const string BeginsWithValue = "BeginsWith";
        private const string EndsWithValue = "EndsWith";
        private const string LessThanValue = "LessThan";
        private const string LessThanOrEqualValue = "LessThanOrEqual";
        private const string GreaterThanValue = "GreaterThan";
        private const string GreaterThanOrEqualValue = "GreaterThanOrEqual";
        private const string RegExValue = "RegEx";

        /// <summary> Any. </summary>
        public static UriFileExtensionOperator Any { get; } = new UriFileExtensionOperator(AnyValue);
        /// <summary> Equal. </summary>
        public static UriFileExtensionOperator Equal { get; } = new UriFileExtensionOperator(EqualValue);
        /// <summary> Contains. </summary>
        public static UriFileExtensionOperator Contains { get; } = new UriFileExtensionOperator(ContainsValue);
        /// <summary> BeginsWith. </summary>
        public static UriFileExtensionOperator BeginsWith { get; } = new UriFileExtensionOperator(BeginsWithValue);
        /// <summary> EndsWith. </summary>
        public static UriFileExtensionOperator EndsWith { get; } = new UriFileExtensionOperator(EndsWithValue);
        /// <summary> LessThan. </summary>
        public static UriFileExtensionOperator LessThan { get; } = new UriFileExtensionOperator(LessThanValue);
        /// <summary> LessThanOrEqual. </summary>
        public static UriFileExtensionOperator LessThanOrEqual { get; } = new UriFileExtensionOperator(LessThanOrEqualValue);
        /// <summary> GreaterThan. </summary>
        public static UriFileExtensionOperator GreaterThan { get; } = new UriFileExtensionOperator(GreaterThanValue);
        /// <summary> GreaterThanOrEqual. </summary>
        public static UriFileExtensionOperator GreaterThanOrEqual { get; } = new UriFileExtensionOperator(GreaterThanOrEqualValue);
        /// <summary> RegEx. </summary>
        public static UriFileExtensionOperator RegEx { get; } = new UriFileExtensionOperator(RegExValue);
        /// <summary> Determines if two <see cref="UriFileExtensionOperator"/> values are the same. </summary>
        public static bool operator ==(UriFileExtensionOperator left, UriFileExtensionOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UriFileExtensionOperator"/> values are not the same. </summary>
        public static bool operator !=(UriFileExtensionOperator left, UriFileExtensionOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UriFileExtensionOperator"/>. </summary>
        public static implicit operator UriFileExtensionOperator(string value) => new UriFileExtensionOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UriFileExtensionOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UriFileExtensionOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
