// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes operator to be matched. </summary>
    public readonly partial struct SocketAddressOperator : IEquatable<SocketAddressOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SocketAddressOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SocketAddressOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnyValue = "Any";
        private const string IPMatchValue = "IPMatch";

        /// <summary> Any. </summary>
        public static SocketAddressOperator Any { get; } = new SocketAddressOperator(AnyValue);
        /// <summary> IPMatch. </summary>
        public static SocketAddressOperator IPMatch { get; } = new SocketAddressOperator(IPMatchValue);
        /// <summary> Determines if two <see cref="SocketAddressOperator"/> values are the same. </summary>
        public static bool operator ==(SocketAddressOperator left, SocketAddressOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SocketAddressOperator"/> values are not the same. </summary>
        public static bool operator !=(SocketAddressOperator left, SocketAddressOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SocketAddressOperator"/>. </summary>
        public static implicit operator SocketAddressOperator(string value) => new SocketAddressOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SocketAddressOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SocketAddressOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
