// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes the properties of an existing Shared Private Link Resource to use when connecting to a private origin. </summary>
    public partial class SharedPrivateLinkResourceProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SharedPrivateLinkResourceProperties"/>. </summary>
        public SharedPrivateLinkResourceProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SharedPrivateLinkResourceProperties"/>. </summary>
        /// <param name="privateLink"> The resource id of the resource the shared private link resource is for. </param>
        /// <param name="privateLinkLocation"> The location of the shared private link resource. </param>
        /// <param name="groupId"> The group id from the provider of resource the shared private link resource is for. </param>
        /// <param name="requestMessage"> The request message for requesting approval of the shared private link resource. </param>
        /// <param name="status"> Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SharedPrivateLinkResourceProperties(WritableSubResource privateLink, string privateLinkLocation, string groupId, string requestMessage, SharedPrivateLinkResourceStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrivateLink = privateLink;
            PrivateLinkLocation = privateLinkLocation;
            GroupId = groupId;
            RequestMessage = requestMessage;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The resource id of the resource the shared private link resource is for. </summary>
        internal WritableSubResource PrivateLink { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier PrivateLinkId
        {
            get => PrivateLink is null ? default : PrivateLink.Id;
            set
            {
                if (PrivateLink is null)
                    PrivateLink = new WritableSubResource();
                PrivateLink.Id = value;
            }
        }

        /// <summary> The location of the shared private link resource. </summary>
        public string PrivateLinkLocation { get; set; }
        /// <summary> The group id from the provider of resource the shared private link resource is for. </summary>
        public string GroupId { get; set; }
        /// <summary> The request message for requesting approval of the shared private link resource. </summary>
        public string RequestMessage { get; set; }
        /// <summary> Status of the shared private link resource. Can be Pending, Approved, Rejected, Disconnected, or Timeout. </summary>
        public SharedPrivateLinkResourceStatus? Status { get; set; }
    }
}
