// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Caching behavior for the requests. </summary>
    public readonly partial struct RuleCacheBehavior : IEquatable<RuleCacheBehavior>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RuleCacheBehavior"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RuleCacheBehavior(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HonorOriginValue = "HonorOrigin";
        private const string OverrideAlwaysValue = "OverrideAlways";
        private const string OverrideIfOriginMissingValue = "OverrideIfOriginMissing";

        /// <summary> HonorOrigin. </summary>
        public static RuleCacheBehavior HonorOrigin { get; } = new RuleCacheBehavior(HonorOriginValue);
        /// <summary> OverrideAlways. </summary>
        public static RuleCacheBehavior OverrideAlways { get; } = new RuleCacheBehavior(OverrideAlwaysValue);
        /// <summary> OverrideIfOriginMissing. </summary>
        public static RuleCacheBehavior OverrideIfOriginMissing { get; } = new RuleCacheBehavior(OverrideIfOriginMissingValue);
        /// <summary> Determines if two <see cref="RuleCacheBehavior"/> values are the same. </summary>
        public static bool operator ==(RuleCacheBehavior left, RuleCacheBehavior right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RuleCacheBehavior"/> values are not the same. </summary>
        public static bool operator !=(RuleCacheBehavior left, RuleCacheBehavior right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RuleCacheBehavior"/>. </summary>
        public static implicit operator RuleCacheBehavior(string value) => new RuleCacheBehavior(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RuleCacheBehavior other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RuleCacheBehavior other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
