// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The JSON object that contains the properties to determine origin health using real requests/responses. </summary>
    public partial class ResponseBasedOriginErrorDetectionSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResponseBasedOriginErrorDetectionSettings"/>. </summary>
        public ResponseBasedOriginErrorDetectionSettings()
        {
            HttpErrorRanges = new ChangeTrackingList<HttpErrorRange>();
        }

        /// <summary> Initializes a new instance of <see cref="ResponseBasedOriginErrorDetectionSettings"/>. </summary>
        /// <param name="responseBasedDetectedErrorType"> Type of response errors for real user requests for which origin will be deemed unhealthy. </param>
        /// <param name="responseBasedFailoverThresholdPercentage"> The percentage of failed requests in the sample where failover should trigger. </param>
        /// <param name="httpErrorRanges"> The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResponseBasedOriginErrorDetectionSettings(ResponseBasedDetectedErrorType? responseBasedDetectedErrorType, int? responseBasedFailoverThresholdPercentage, IList<HttpErrorRange> httpErrorRanges, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResponseBasedDetectedErrorType = responseBasedDetectedErrorType;
            ResponseBasedFailoverThresholdPercentage = responseBasedFailoverThresholdPercentage;
            HttpErrorRanges = httpErrorRanges;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of response errors for real user requests for which origin will be deemed unhealthy. </summary>
        public ResponseBasedDetectedErrorType? ResponseBasedDetectedErrorType { get; set; }
        /// <summary> The percentage of failed requests in the sample where failover should trigger. </summary>
        public int? ResponseBasedFailoverThresholdPercentage { get; set; }
        /// <summary> The list of Http status code ranges that are considered as server errors for origin and it is marked as unhealthy. </summary>
        public IList<HttpErrorRange> HttpErrorRanges { get; }
    }
}
