// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Cdn.Models
{
    public partial class ResponseBasedOriginErrorDetectionSettings : IUtf8JsonSerializable, IJsonModel<ResponseBasedOriginErrorDetectionSettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ResponseBasedOriginErrorDetectionSettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ResponseBasedOriginErrorDetectionSettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResponseBasedOriginErrorDetectionSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResponseBasedOriginErrorDetectionSettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ResponseBasedDetectedErrorType))
            {
                writer.WritePropertyName("responseBasedDetectedErrorTypes"u8);
                writer.WriteStringValue(ResponseBasedDetectedErrorType.Value.ToSerialString());
            }
            if (Optional.IsDefined(ResponseBasedFailoverThresholdPercentage))
            {
                writer.WritePropertyName("responseBasedFailoverThresholdPercentage"u8);
                writer.WriteNumberValue(ResponseBasedFailoverThresholdPercentage.Value);
            }
            if (Optional.IsCollectionDefined(HttpErrorRanges))
            {
                writer.WritePropertyName("httpErrorRanges"u8);
                writer.WriteStartArray();
                foreach (var item in HttpErrorRanges)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ResponseBasedOriginErrorDetectionSettings IJsonModel<ResponseBasedOriginErrorDetectionSettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResponseBasedOriginErrorDetectionSettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ResponseBasedOriginErrorDetectionSettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeResponseBasedOriginErrorDetectionSettings(document.RootElement, options);
        }

        internal static ResponseBasedOriginErrorDetectionSettings DeserializeResponseBasedOriginErrorDetectionSettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResponseBasedDetectedErrorType? responseBasedDetectedErrorTypes = default;
            int? responseBasedFailoverThresholdPercentage = default;
            IList<HttpErrorRange> httpErrorRanges = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("responseBasedDetectedErrorTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    responseBasedDetectedErrorTypes = property.Value.GetString().ToResponseBasedDetectedErrorType();
                    continue;
                }
                if (property.NameEquals("responseBasedFailoverThresholdPercentage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    responseBasedFailoverThresholdPercentage = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("httpErrorRanges"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HttpErrorRange> array = new List<HttpErrorRange>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HttpErrorRange.DeserializeHttpErrorRange(item, options));
                    }
                    httpErrorRanges = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ResponseBasedOriginErrorDetectionSettings(responseBasedDetectedErrorTypes, responseBasedFailoverThresholdPercentage, httpErrorRanges ?? new ChangeTrackingList<HttpErrorRange>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ResponseBasedOriginErrorDetectionSettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResponseBasedOriginErrorDetectionSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ResponseBasedOriginErrorDetectionSettings)} does not support writing '{options.Format}' format.");
            }
        }

        ResponseBasedOriginErrorDetectionSettings IPersistableModel<ResponseBasedOriginErrorDetectionSettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ResponseBasedOriginErrorDetectionSettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeResponseBasedOriginErrorDetectionSettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ResponseBasedOriginErrorDetectionSettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ResponseBasedOriginErrorDetectionSettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
