// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Cdn.Models
{
    internal static partial class ResponseBasedDetectedErrorTypeExtensions
    {
        public static string ToSerialString(this ResponseBasedDetectedErrorType value) => value switch
        {
            ResponseBasedDetectedErrorType.None => "None",
            ResponseBasedDetectedErrorType.TcpErrorsOnly => "TcpErrorsOnly",
            ResponseBasedDetectedErrorType.TcpAndHttpErrors => "TcpAndHttpErrors",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ResponseBasedDetectedErrorType value.")
        };

        public static ResponseBasedDetectedErrorType ToResponseBasedDetectedErrorType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "None")) return ResponseBasedDetectedErrorType.None;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TcpErrorsOnly")) return ResponseBasedDetectedErrorType.TcpErrorsOnly;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "TcpAndHttpErrors")) return ResponseBasedDetectedErrorType.TcpAndHttpErrors;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ResponseBasedDetectedErrorType value.");
        }
    }
}
