// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The ResourcesResponseEndpointsItem. </summary>
    public partial class ResourcesResponseEndpointsItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourcesResponseEndpointsItem"/>. </summary>
        internal ResourcesResponseEndpointsItem()
        {
            CustomDomains = new ChangeTrackingList<ResourcesResponseEndpointsPropertiesItemsItem>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourcesResponseEndpointsItem"/>. </summary>
        /// <param name="id"></param>
        /// <param name="name"></param>
        /// <param name="history"></param>
        /// <param name="customDomains"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourcesResponseEndpointsItem(string id, string name, bool? history, IReadOnlyList<ResourcesResponseEndpointsPropertiesItemsItem> customDomains, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            History = history;
            CustomDomains = customDomains;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the id. </summary>
        public string Id { get; }
        /// <summary> Gets the name. </summary>
        public string Name { get; }
        /// <summary> Gets the history. </summary>
        public bool? History { get; }
        /// <summary> Gets the custom domains. </summary>
        public IReadOnlyList<ResourcesResponseEndpointsPropertiesItemsItem> CustomDomains { get; }
    }
}
