// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Resources Response. </summary>
    public partial class ResourcesResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourcesResponse"/>. </summary>
        internal ResourcesResponse()
        {
            Endpoints = new ChangeTrackingList<ResourcesResponseEndpointsItem>();
            CustomDomains = new ChangeTrackingList<ResourcesResponseCustomDomainsItem>();
        }

        /// <summary> Initializes a new instance of <see cref="ResourcesResponse"/>. </summary>
        /// <param name="endpoints"></param>
        /// <param name="customDomains"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourcesResponse(IReadOnlyList<ResourcesResponseEndpointsItem> endpoints, IReadOnlyList<ResourcesResponseCustomDomainsItem> customDomains, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Endpoints = endpoints;
            CustomDomains = customDomains;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the endpoints. </summary>
        public IReadOnlyList<ResourcesResponseEndpointsItem> Endpoints { get; }
        /// <summary> Gets the custom domains. </summary>
        public IReadOnlyList<ResourcesResponseCustomDomainsItem> CustomDomains { get; }
    }
}
