// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes operator to be matched. </summary>
    public readonly partial struct RequestSchemeOperator : IEquatable<RequestSchemeOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RequestSchemeOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RequestSchemeOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualValue = "Equal";

        /// <summary> Equal. </summary>
        public static RequestSchemeOperator Equal { get; } = new RequestSchemeOperator(EqualValue);
        /// <summary> Determines if two <see cref="RequestSchemeOperator"/> values are the same. </summary>
        public static bool operator ==(RequestSchemeOperator left, RequestSchemeOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RequestSchemeOperator"/> values are not the same. </summary>
        public static bool operator !=(RequestSchemeOperator left, RequestSchemeOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RequestSchemeOperator"/>. </summary>
        public static implicit operator RequestSchemeOperator(string value) => new RequestSchemeOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RequestSchemeOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RequestSchemeOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
