// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The RequestSchemeMatchConditionMatchValue. </summary>
    public readonly partial struct RequestSchemeMatchConditionMatchValue : IEquatable<RequestSchemeMatchConditionMatchValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RequestSchemeMatchConditionMatchValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RequestSchemeMatchConditionMatchValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HttpValue = "HTTP";
        private const string HttpsValue = "HTTPS";

        /// <summary> HTTP. </summary>
        public static RequestSchemeMatchConditionMatchValue Http { get; } = new RequestSchemeMatchConditionMatchValue(HttpValue);
        /// <summary> HTTPS. </summary>
        public static RequestSchemeMatchConditionMatchValue Https { get; } = new RequestSchemeMatchConditionMatchValue(HttpsValue);
        /// <summary> Determines if two <see cref="RequestSchemeMatchConditionMatchValue"/> values are the same. </summary>
        public static bool operator ==(RequestSchemeMatchConditionMatchValue left, RequestSchemeMatchConditionMatchValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RequestSchemeMatchConditionMatchValue"/> values are not the same. </summary>
        public static bool operator !=(RequestSchemeMatchConditionMatchValue left, RequestSchemeMatchConditionMatchValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RequestSchemeMatchConditionMatchValue"/>. </summary>
        public static implicit operator RequestSchemeMatchConditionMatchValue(string value) => new RequestSchemeMatchConditionMatchValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RequestSchemeMatchConditionMatchValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RequestSchemeMatchConditionMatchValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
