// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Cdn.Models
{
    public partial class RankingsResponseTablesPropertiesItemsItem : IUtf8JsonSerializable, IJsonModel<RankingsResponseTablesPropertiesItemsItem>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RankingsResponseTablesPropertiesItemsItem>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RankingsResponseTablesPropertiesItemsItem>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RankingsResponseTablesPropertiesItemsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RankingsResponseTablesPropertiesItemsItem)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsCollectionDefined(Metrics))
            {
                writer.WritePropertyName("metrics"u8);
                writer.WriteStartArray();
                foreach (var item in Metrics)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RankingsResponseTablesPropertiesItemsItem IJsonModel<RankingsResponseTablesPropertiesItemsItem>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RankingsResponseTablesPropertiesItemsItem>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RankingsResponseTablesPropertiesItemsItem)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRankingsResponseTablesPropertiesItemsItem(document.RootElement, options);
        }

        internal static RankingsResponseTablesPropertiesItemsItem DeserializeRankingsResponseTablesPropertiesItemsItem(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            IReadOnlyList<RankingsResponseTablesPropertiesItemsMetricsItem> metrics = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("metrics"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RankingsResponseTablesPropertiesItemsMetricsItem> array = new List<RankingsResponseTablesPropertiesItemsMetricsItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RankingsResponseTablesPropertiesItemsMetricsItem.DeserializeRankingsResponseTablesPropertiesItemsMetricsItem(item, options));
                    }
                    metrics = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RankingsResponseTablesPropertiesItemsItem(name, metrics ?? new ChangeTrackingList<RankingsResponseTablesPropertiesItemsMetricsItem>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RankingsResponseTablesPropertiesItemsItem>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RankingsResponseTablesPropertiesItemsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RankingsResponseTablesPropertiesItemsItem)} does not support writing '{options.Format}' format.");
            }
        }

        RankingsResponseTablesPropertiesItemsItem IPersistableModel<RankingsResponseTablesPropertiesItemsItem>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RankingsResponseTablesPropertiesItemsItem>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRankingsResponseTablesPropertiesItemsItem(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RankingsResponseTablesPropertiesItemsItem)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RankingsResponseTablesPropertiesItemsItem>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
