// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Parameters required for profile upgrade. </summary>
    public partial class ProfileUpgradeContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProfileUpgradeContent"/>. </summary>
        /// <param name="wafMappingList"> Web Application Firewall (WAF) and security policy mapping for the profile upgrade. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="wafMappingList"/> is null. </exception>
        public ProfileUpgradeContent(IEnumerable<ProfileChangeSkuWafMapping> wafMappingList)
        {
            Argument.AssertNotNull(wafMappingList, nameof(wafMappingList));

            WafMappingList = wafMappingList.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ProfileUpgradeContent"/>. </summary>
        /// <param name="wafMappingList"> Web Application Firewall (WAF) and security policy mapping for the profile upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProfileUpgradeContent(IList<ProfileChangeSkuWafMapping> wafMappingList, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WafMappingList = wafMappingList;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ProfileUpgradeContent"/> for deserialization. </summary>
        internal ProfileUpgradeContent()
        {
        }

        /// <summary> Web Application Firewall (WAF) and security policy mapping for the profile upgrade. </summary>
        public IList<ProfileChangeSkuWafMapping> WafMappingList { get; }
    }
}
