// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Cdn.Models
{
    public partial class ProfileUpgradeContent : IUtf8JsonSerializable, IJsonModel<ProfileUpgradeContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ProfileUpgradeContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ProfileUpgradeContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProfileUpgradeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProfileUpgradeContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("wafMappingList"u8);
            writer.WriteStartArray();
            foreach (var item in WafMappingList)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ProfileUpgradeContent IJsonModel<ProfileUpgradeContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProfileUpgradeContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProfileUpgradeContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeProfileUpgradeContent(document.RootElement, options);
        }

        internal static ProfileUpgradeContent DeserializeProfileUpgradeContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<ProfileChangeSkuWafMapping> wafMappingList = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("wafMappingList"u8))
                {
                    List<ProfileChangeSkuWafMapping> array = new List<ProfileChangeSkuWafMapping>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ProfileChangeSkuWafMapping.DeserializeProfileChangeSkuWafMapping(item, options));
                    }
                    wafMappingList = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ProfileUpgradeContent(wafMappingList, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ProfileUpgradeContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProfileUpgradeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ProfileUpgradeContent)} does not support writing '{options.Format}' format.");
            }
        }

        ProfileUpgradeContent IPersistableModel<ProfileUpgradeContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProfileUpgradeContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeProfileUpgradeContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ProfileUpgradeContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ProfileUpgradeContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
