// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Resource status of the profile. </summary>
    public readonly partial struct ProfileResourceState : IEquatable<ProfileResourceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProfileResourceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProfileResourceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string ActiveValue = "Active";
        private const string DeletingValue = "Deleting";
        private const string DisabledValue = "Disabled";
        private const string MigratingValue = "Migrating";
        private const string MigratedValue = "Migrated";
        private const string PendingMigrationCommitValue = "PendingMigrationCommit";
        private const string CommittingMigrationValue = "CommittingMigration";
        private const string AbortingMigrationValue = "AbortingMigration";

        /// <summary> Creating. </summary>
        public static ProfileResourceState Creating { get; } = new ProfileResourceState(CreatingValue);
        /// <summary> Active. </summary>
        public static ProfileResourceState Active { get; } = new ProfileResourceState(ActiveValue);
        /// <summary> Deleting. </summary>
        public static ProfileResourceState Deleting { get; } = new ProfileResourceState(DeletingValue);
        /// <summary> Disabled. </summary>
        public static ProfileResourceState Disabled { get; } = new ProfileResourceState(DisabledValue);
        /// <summary> Migrating. </summary>
        public static ProfileResourceState Migrating { get; } = new ProfileResourceState(MigratingValue);
        /// <summary> Migrated. </summary>
        public static ProfileResourceState Migrated { get; } = new ProfileResourceState(MigratedValue);
        /// <summary> PendingMigrationCommit. </summary>
        public static ProfileResourceState PendingMigrationCommit { get; } = new ProfileResourceState(PendingMigrationCommitValue);
        /// <summary> CommittingMigration. </summary>
        public static ProfileResourceState CommittingMigration { get; } = new ProfileResourceState(CommittingMigrationValue);
        /// <summary> AbortingMigration. </summary>
        public static ProfileResourceState AbortingMigration { get; } = new ProfileResourceState(AbortingMigrationValue);
        /// <summary> Determines if two <see cref="ProfileResourceState"/> values are the same. </summary>
        public static bool operator ==(ProfileResourceState left, ProfileResourceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProfileResourceState"/> values are not the same. </summary>
        public static bool operator !=(ProfileResourceState left, ProfileResourceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProfileResourceState"/>. </summary>
        public static implicit operator ProfileResourceState(string value) => new ProfileResourceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProfileResourceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProfileResourceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
