// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The ProfileResourceGetWafLogAnalyticsRankingsOptions. </summary>
    public partial class ProfileResourceGetWafLogAnalyticsRankingsOptions
    {
        /// <summary> Initializes a new instance of <see cref="ProfileResourceGetWafLogAnalyticsRankingsOptions"/>. </summary>
        /// <param name="metrics"> The metrics. </param>
        /// <param name="dateTimeBegin"> The dateTimeBegin. </param>
        /// <param name="dateTimeEnd"> The dateTimeEnd. </param>
        /// <param name="maxRanking"> The maxRanking. </param>
        /// <param name="rankings"> The rankings. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="metrics"/> or <paramref name="rankings"/> is null. </exception>
        public ProfileResourceGetWafLogAnalyticsRankingsOptions(IEnumerable<WafMetric> metrics, DateTimeOffset dateTimeBegin, DateTimeOffset dateTimeEnd, int maxRanking, IEnumerable<WafRankingType> rankings)
        {
            Argument.AssertNotNull(metrics, nameof(metrics));
            Argument.AssertNotNull(rankings, nameof(rankings));

            Metrics = metrics.ToList();
            DateTimeBegin = dateTimeBegin;
            DateTimeEnd = dateTimeEnd;
            MaxRanking = maxRanking;
            Rankings = rankings.ToList();
            Actions = new ChangeTrackingList<WafAction>();
            RuleTypes = new ChangeTrackingList<WafRuleType>();
        }

        /// <summary> Initializes a new instance of <see cref="ProfileResourceGetWafLogAnalyticsRankingsOptions"/> for deserialization. </summary>
        internal ProfileResourceGetWafLogAnalyticsRankingsOptions()
        {
        }

        /// <summary> The metrics. </summary>
        public IList<WafMetric> Metrics { get; }
        /// <summary> The dateTimeBegin. </summary>
        public DateTimeOffset DateTimeBegin { get; }
        /// <summary> The dateTimeEnd. </summary>
        public DateTimeOffset DateTimeEnd { get; }
        /// <summary> The maxRanking. </summary>
        public int MaxRanking { get; }
        /// <summary> The rankings. </summary>
        public IList<WafRankingType> Rankings { get; }
        /// <summary> The actions. </summary>
        public IList<WafAction> Actions { get; }
        /// <summary> The ruleTypes. </summary>
        public IList<WafRuleType> RuleTypes { get; }
    }
}
