// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The ProfileResourceGetWafLogAnalyticsMetricsOptions. </summary>
    public partial class ProfileResourceGetWafLogAnalyticsMetricsOptions
    {
        /// <summary> Initializes a new instance of <see cref="ProfileResourceGetWafLogAnalyticsMetricsOptions"/>. </summary>
        /// <param name="metrics"> The metrics. </param>
        /// <param name="dateTimeBegin"> The dateTimeBegin. </param>
        /// <param name="dateTimeEnd"> The dateTimeEnd. </param>
        /// <param name="granularity"> The granularity. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="metrics"/> is null. </exception>
        public ProfileResourceGetWafLogAnalyticsMetricsOptions(IEnumerable<WafMetric> metrics, DateTimeOffset dateTimeBegin, DateTimeOffset dateTimeEnd, WafGranularity granularity)
        {
            Argument.AssertNotNull(metrics, nameof(metrics));

            Metrics = metrics.ToList();
            DateTimeBegin = dateTimeBegin;
            DateTimeEnd = dateTimeEnd;
            Granularity = granularity;
            Actions = new ChangeTrackingList<WafAction>();
            GroupBy = new ChangeTrackingList<WafRankingGroupBy>();
            RuleTypes = new ChangeTrackingList<WafRuleType>();
        }

        /// <summary> Initializes a new instance of <see cref="ProfileResourceGetWafLogAnalyticsMetricsOptions"/> for deserialization. </summary>
        internal ProfileResourceGetWafLogAnalyticsMetricsOptions()
        {
        }

        /// <summary> The metrics. </summary>
        public IList<WafMetric> Metrics { get; }
        /// <summary> The dateTimeBegin. </summary>
        public DateTimeOffset DateTimeBegin { get; }
        /// <summary> The dateTimeEnd. </summary>
        public DateTimeOffset DateTimeEnd { get; }
        /// <summary> The granularity. </summary>
        public WafGranularity Granularity { get; }
        /// <summary> The actions. </summary>
        public IList<WafAction> Actions { get; }
        /// <summary> The groupBy. </summary>
        public IList<WafRankingGroupBy> GroupBy { get; }
        /// <summary> The ruleTypes. </summary>
        public IList<WafRuleType> RuleTypes { get; }
    }
}
