// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The ProfileResourceGetLogAnalyticsMetricsOptions. </summary>
    public partial class ProfileResourceGetLogAnalyticsMetricsOptions
    {
        /// <summary> Initializes a new instance of <see cref="ProfileResourceGetLogAnalyticsMetricsOptions"/>. </summary>
        /// <param name="metrics"> The metrics. </param>
        /// <param name="dateTimeBegin"> The dateTimeBegin. </param>
        /// <param name="dateTimeEnd"> The dateTimeEnd. </param>
        /// <param name="granularity"> The granularity. </param>
        /// <param name="customDomains"> The customDomains. </param>
        /// <param name="protocols"> The protocols. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="metrics"/>, <paramref name="customDomains"/> or <paramref name="protocols"/> is null. </exception>
        public ProfileResourceGetLogAnalyticsMetricsOptions(IEnumerable<LogMetric> metrics, DateTimeOffset dateTimeBegin, DateTimeOffset dateTimeEnd, LogMetricsGranularity granularity, IEnumerable<string> customDomains, IEnumerable<string> protocols)
        {
            Argument.AssertNotNull(metrics, nameof(metrics));
            Argument.AssertNotNull(customDomains, nameof(customDomains));
            Argument.AssertNotNull(protocols, nameof(protocols));

            Metrics = metrics.ToList();
            DateTimeBegin = dateTimeBegin;
            DateTimeEnd = dateTimeEnd;
            Granularity = granularity;
            CustomDomains = customDomains.ToList();
            Protocols = protocols.ToList();
            GroupBy = new ChangeTrackingList<LogMetricsGroupBy>();
            Continents = new ChangeTrackingList<string>();
            CountryOrRegions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ProfileResourceGetLogAnalyticsMetricsOptions"/> for deserialization. </summary>
        internal ProfileResourceGetLogAnalyticsMetricsOptions()
        {
        }

        /// <summary> The metrics. </summary>
        public IList<LogMetric> Metrics { get; }
        /// <summary> The dateTimeBegin. </summary>
        public DateTimeOffset DateTimeBegin { get; }
        /// <summary> The dateTimeEnd. </summary>
        public DateTimeOffset DateTimeEnd { get; }
        /// <summary> The granularity. </summary>
        public LogMetricsGranularity Granularity { get; }
        /// <summary> The customDomains. </summary>
        public IList<string> CustomDomains { get; }
        /// <summary> The protocols. </summary>
        public IList<string> Protocols { get; }
        /// <summary> The groupBy. </summary>
        public IList<LogMetricsGroupBy> GroupBy { get; }
        /// <summary> The continents. </summary>
        public IList<string> Continents { get; }
        /// <summary> The countryOrRegions. </summary>
        public IList<string> CountryOrRegions { get; }
    }
}
