// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Cdn.Models
{
    public partial class ProfileLogScrubbing : IUtf8JsonSerializable, IJsonModel<ProfileLogScrubbing>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ProfileLogScrubbing>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ProfileLogScrubbing>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProfileLogScrubbing>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProfileLogScrubbing)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ScrubbingRules))
            {
                writer.WritePropertyName("scrubbingRules"u8);
                writer.WriteStartArray();
                foreach (var item in ScrubbingRules)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ProfileLogScrubbing IJsonModel<ProfileLogScrubbing>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProfileLogScrubbing>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ProfileLogScrubbing)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeProfileLogScrubbing(document.RootElement, options);
        }

        internal static ProfileLogScrubbing DeserializeProfileLogScrubbing(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ProfileScrubbingState? state = default;
            IList<ProfileScrubbingRules> scrubbingRules = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new ProfileScrubbingState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("scrubbingRules"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ProfileScrubbingRules> array = new List<ProfileScrubbingRules>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ProfileScrubbingRules.DeserializeProfileScrubbingRules(item, options));
                    }
                    scrubbingRules = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ProfileLogScrubbing(state, scrubbingRules ?? new ChangeTrackingList<ProfileScrubbingRules>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ProfileLogScrubbing>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProfileLogScrubbing>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ProfileLogScrubbing)} does not support writing '{options.Format}' format.");
            }
        }

        ProfileLogScrubbing IPersistableModel<ProfileLogScrubbing>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ProfileLogScrubbing>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeProfileLogScrubbing(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ProfileLogScrubbing)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ProfileLogScrubbing>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
