// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes what transforms are applied before matching. </summary>
    public readonly partial struct PreTransformCategory : IEquatable<PreTransformCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PreTransformCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PreTransformCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowercaseValue = "Lowercase";
        private const string UppercaseValue = "Uppercase";
        private const string TrimValue = "Trim";
        private const string UriDecodeValue = "UrlDecode";
        private const string UriEncodeValue = "UrlEncode";
        private const string RemoveNullsValue = "RemoveNulls";

        /// <summary> Lowercase. </summary>
        public static PreTransformCategory Lowercase { get; } = new PreTransformCategory(LowercaseValue);
        /// <summary> Uppercase. </summary>
        public static PreTransformCategory Uppercase { get; } = new PreTransformCategory(UppercaseValue);
        /// <summary> Trim. </summary>
        public static PreTransformCategory Trim { get; } = new PreTransformCategory(TrimValue);
        /// <summary> UrlDecode. </summary>
        public static PreTransformCategory UriDecode { get; } = new PreTransformCategory(UriDecodeValue);
        /// <summary> UrlEncode. </summary>
        public static PreTransformCategory UriEncode { get; } = new PreTransformCategory(UriEncodeValue);
        /// <summary> RemoveNulls. </summary>
        public static PreTransformCategory RemoveNulls { get; } = new PreTransformCategory(RemoveNullsValue);
        /// <summary> Determines if two <see cref="PreTransformCategory"/> values are the same. </summary>
        public static bool operator ==(PreTransformCategory left, PreTransformCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PreTransformCategory"/> values are not the same. </summary>
        public static bool operator !=(PreTransformCategory left, PreTransformCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PreTransformCategory"/>. </summary>
        public static implicit operator PreTransformCategory(string value) => new PreTransformCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PreTransformCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PreTransformCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
