// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Describes operator to be matched. </summary>
    public readonly partial struct PostArgsOperator : IEquatable<PostArgsOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PostArgsOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PostArgsOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnyValue = "Any";
        private const string EqualValue = "Equal";
        private const string ContainsValue = "Contains";
        private const string BeginsWithValue = "BeginsWith";
        private const string EndsWithValue = "EndsWith";
        private const string LessThanValue = "LessThan";
        private const string LessThanOrEqualValue = "LessThanOrEqual";
        private const string GreaterThanValue = "GreaterThan";
        private const string GreaterThanOrEqualValue = "GreaterThanOrEqual";
        private const string RegExValue = "RegEx";

        /// <summary> Any. </summary>
        public static PostArgsOperator Any { get; } = new PostArgsOperator(AnyValue);
        /// <summary> Equal. </summary>
        public static PostArgsOperator Equal { get; } = new PostArgsOperator(EqualValue);
        /// <summary> Contains. </summary>
        public static PostArgsOperator Contains { get; } = new PostArgsOperator(ContainsValue);
        /// <summary> BeginsWith. </summary>
        public static PostArgsOperator BeginsWith { get; } = new PostArgsOperator(BeginsWithValue);
        /// <summary> EndsWith. </summary>
        public static PostArgsOperator EndsWith { get; } = new PostArgsOperator(EndsWithValue);
        /// <summary> LessThan. </summary>
        public static PostArgsOperator LessThan { get; } = new PostArgsOperator(LessThanValue);
        /// <summary> LessThanOrEqual. </summary>
        public static PostArgsOperator LessThanOrEqual { get; } = new PostArgsOperator(LessThanOrEqualValue);
        /// <summary> GreaterThan. </summary>
        public static PostArgsOperator GreaterThan { get; } = new PostArgsOperator(GreaterThanValue);
        /// <summary> GreaterThanOrEqual. </summary>
        public static PostArgsOperator GreaterThanOrEqual { get; } = new PostArgsOperator(GreaterThanOrEqualValue);
        /// <summary> RegEx. </summary>
        public static PostArgsOperator RegEx { get; } = new PostArgsOperator(RegExValue);
        /// <summary> Determines if two <see cref="PostArgsOperator"/> values are the same. </summary>
        public static bool operator ==(PostArgsOperator left, PostArgsOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PostArgsOperator"/> values are not the same. </summary>
        public static bool operator !=(PostArgsOperator left, PostArgsOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PostArgsOperator"/>. </summary>
        public static implicit operator PostArgsOperator(string value) => new PostArgsOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PostArgsOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PostArgsOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
