// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;
using System.Globalization;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> If the action type is block, this field defines the default customer overridable http response status code. </summary>
    public readonly partial struct PolicySettingsDefaultCustomBlockResponseStatusCode : IEquatable<PolicySettingsDefaultCustomBlockResponseStatusCode>
    {
        private readonly int _value;

        /// <summary> Initializes a new instance of <see cref="PolicySettingsDefaultCustomBlockResponseStatusCode"/>. </summary>
        public PolicySettingsDefaultCustomBlockResponseStatusCode(int value)
        {
            _value = value;
        }

        private const int TwoHundredValue = 200;
        private const int FourHundredThreeValue = 403;
        private const int FourHundredFiveValue = 405;
        private const int FourHundredSixValue = 406;
        private const int FourHundredTwentyNineValue = 429;

        /// <summary> 200. </summary>
        public static PolicySettingsDefaultCustomBlockResponseStatusCode TwoHundred { get; } = new PolicySettingsDefaultCustomBlockResponseStatusCode(TwoHundredValue);
        /// <summary> 403. </summary>
        public static PolicySettingsDefaultCustomBlockResponseStatusCode FourHundredThree { get; } = new PolicySettingsDefaultCustomBlockResponseStatusCode(FourHundredThreeValue);
        /// <summary> 405. </summary>
        public static PolicySettingsDefaultCustomBlockResponseStatusCode FourHundredFive { get; } = new PolicySettingsDefaultCustomBlockResponseStatusCode(FourHundredFiveValue);
        /// <summary> 406. </summary>
        public static PolicySettingsDefaultCustomBlockResponseStatusCode FourHundredSix { get; } = new PolicySettingsDefaultCustomBlockResponseStatusCode(FourHundredSixValue);
        /// <summary> 429. </summary>
        public static PolicySettingsDefaultCustomBlockResponseStatusCode FourHundredTwentyNine { get; } = new PolicySettingsDefaultCustomBlockResponseStatusCode(FourHundredTwentyNineValue);

        internal int ToSerialInt32() => _value;

        /// <summary> Determines if two <see cref="PolicySettingsDefaultCustomBlockResponseStatusCode"/> values are the same. </summary>
        public static bool operator ==(PolicySettingsDefaultCustomBlockResponseStatusCode left, PolicySettingsDefaultCustomBlockResponseStatusCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicySettingsDefaultCustomBlockResponseStatusCode"/> values are not the same. </summary>
        public static bool operator !=(PolicySettingsDefaultCustomBlockResponseStatusCode left, PolicySettingsDefaultCustomBlockResponseStatusCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="int"/> to a <see cref="PolicySettingsDefaultCustomBlockResponseStatusCode"/>. </summary>
        public static implicit operator PolicySettingsDefaultCustomBlockResponseStatusCode(int value) => new PolicySettingsDefaultCustomBlockResponseStatusCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicySettingsDefaultCustomBlockResponseStatusCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicySettingsDefaultCustomBlockResponseStatusCode other) => Equals(_value, other._value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value.GetHashCode();
        /// <inheritdoc />
        public override string ToString() => _value.ToString(CultureInfo.InvariantCulture);
    }
}
