// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> describes if the policy is in enabled state or disabled state. </summary>
    public readonly partial struct PolicyEnabledState : IEquatable<PolicyEnabledState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyEnabledState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyEnabledState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static PolicyEnabledState Disabled { get; } = new PolicyEnabledState(DisabledValue);
        /// <summary> Enabled. </summary>
        public static PolicyEnabledState Enabled { get; } = new PolicyEnabledState(EnabledValue);
        /// <summary> Determines if two <see cref="PolicyEnabledState"/> values are the same. </summary>
        public static bool operator ==(PolicyEnabledState left, PolicyEnabledState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyEnabledState"/> values are not the same. </summary>
        public static bool operator !=(PolicyEnabledState left, PolicyEnabledState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyEnabledState"/>. </summary>
        public static implicit operator PolicyEnabledState(string value) => new PolicyEnabledState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyEnabledState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyEnabledState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
