// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Specifies what scenario the customer wants this CDN endpoint to optimize, e.g. Download, Media services. With this information we can apply scenario driven optimization. </summary>
    public readonly partial struct OptimizationType : IEquatable<OptimizationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OptimizationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OptimizationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GeneralWebDeliveryValue = "GeneralWebDelivery";
        private const string GeneralMediaStreamingValue = "GeneralMediaStreaming";
        private const string VideoOnDemandMediaStreamingValue = "VideoOnDemandMediaStreaming";
        private const string LargeFileDownloadValue = "LargeFileDownload";
        private const string DynamicSiteAccelerationValue = "DynamicSiteAcceleration";

        /// <summary> GeneralWebDelivery. </summary>
        public static OptimizationType GeneralWebDelivery { get; } = new OptimizationType(GeneralWebDeliveryValue);
        /// <summary> GeneralMediaStreaming. </summary>
        public static OptimizationType GeneralMediaStreaming { get; } = new OptimizationType(GeneralMediaStreamingValue);
        /// <summary> VideoOnDemandMediaStreaming. </summary>
        public static OptimizationType VideoOnDemandMediaStreaming { get; } = new OptimizationType(VideoOnDemandMediaStreamingValue);
        /// <summary> LargeFileDownload. </summary>
        public static OptimizationType LargeFileDownload { get; } = new OptimizationType(LargeFileDownloadValue);
        /// <summary> DynamicSiteAcceleration. </summary>
        public static OptimizationType DynamicSiteAcceleration { get; } = new OptimizationType(DynamicSiteAccelerationValue);
        /// <summary> Determines if two <see cref="OptimizationType"/> values are the same. </summary>
        public static bool operator ==(OptimizationType left, OptimizationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OptimizationType"/> values are not the same. </summary>
        public static bool operator !=(OptimizationType left, OptimizationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OptimizationType"/>. </summary>
        public static implicit operator OptimizationType(string value) => new OptimizationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OptimizationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OptimizationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
