// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Web Application Firewall Mapping. </summary>
    public partial class MigrationWebApplicationFirewallMapping
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrationWebApplicationFirewallMapping"/>. </summary>
        public MigrationWebApplicationFirewallMapping()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MigrationWebApplicationFirewallMapping"/>. </summary>
        /// <param name="migratedFrom"> Migration From Waf policy. </param>
        /// <param name="migratedTo"> Migration to Waf policy. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrationWebApplicationFirewallMapping(WritableSubResource migratedFrom, WritableSubResource migratedTo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MigratedFrom = migratedFrom;
            MigratedTo = migratedTo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Migration From Waf policy. </summary>
        internal WritableSubResource MigratedFrom { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier MigratedFromId
        {
            get => MigratedFrom is null ? default : MigratedFrom.Id;
            set
            {
                if (MigratedFrom is null)
                    MigratedFrom = new WritableSubResource();
                MigratedFrom.Id = value;
            }
        }

        /// <summary> Migration to Waf policy. </summary>
        internal WritableSubResource MigratedTo { get; set; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier MigratedToId
        {
            get => MigratedTo is null ? default : MigratedTo.Id;
            set
            {
                if (MigratedTo is null)
                    MigratedTo = new WritableSubResource();
                MigratedTo.Id = value;
            }
        }
    }
}
