// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Cdn.Models
{
    public partial class MigrationWebApplicationFirewallMapping : IUtf8JsonSerializable, IJsonModel<MigrationWebApplicationFirewallMapping>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MigrationWebApplicationFirewallMapping>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MigrationWebApplicationFirewallMapping>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MigrationWebApplicationFirewallMapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MigrationWebApplicationFirewallMapping)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(MigratedFrom))
            {
                writer.WritePropertyName("migratedFrom"u8);
                JsonSerializer.Serialize(writer, MigratedFrom);
            }
            if (Optional.IsDefined(MigratedTo))
            {
                writer.WritePropertyName("migratedTo"u8);
                JsonSerializer.Serialize(writer, MigratedTo);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MigrationWebApplicationFirewallMapping IJsonModel<MigrationWebApplicationFirewallMapping>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MigrationWebApplicationFirewallMapping>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MigrationWebApplicationFirewallMapping)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMigrationWebApplicationFirewallMapping(document.RootElement, options);
        }

        internal static MigrationWebApplicationFirewallMapping DeserializeMigrationWebApplicationFirewallMapping(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            WritableSubResource migratedFrom = default;
            WritableSubResource migratedTo = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("migratedFrom"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    migratedFrom = JsonSerializer.Deserialize<WritableSubResource>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("migratedTo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    migratedTo = JsonSerializer.Deserialize<WritableSubResource>(property.Value.GetRawText());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MigrationWebApplicationFirewallMapping(migratedFrom, migratedTo, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MigrationWebApplicationFirewallMapping>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MigrationWebApplicationFirewallMapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MigrationWebApplicationFirewallMapping)} does not support writing '{options.Format}' format.");
            }
        }

        MigrationWebApplicationFirewallMapping IPersistableModel<MigrationWebApplicationFirewallMapping>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MigrationWebApplicationFirewallMapping>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMigrationWebApplicationFirewallMapping(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MigrationWebApplicationFirewallMapping)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MigrationWebApplicationFirewallMapping>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
