// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Request body for Migrate operation. </summary>
    public partial class MigrationContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrationContent"/>. </summary>
        /// <param name="sku"> Sku for the migration. </param>
        /// <param name="classicResourceReference"> Resource reference of the classic cdn profile or classic frontdoor that need to be migrated. </param>
        /// <param name="profileName"> Name of the new profile that need to be created. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sku"/>, <paramref name="classicResourceReference"/> or <paramref name="profileName"/> is null. </exception>
        public MigrationContent(CdnSku sku, WritableSubResource classicResourceReference, string profileName)
        {
            Argument.AssertNotNull(sku, nameof(sku));
            Argument.AssertNotNull(classicResourceReference, nameof(classicResourceReference));
            Argument.AssertNotNull(profileName, nameof(profileName));

            Sku = sku;
            ClassicResourceReference = classicResourceReference;
            ProfileName = profileName;
            MigrationWebApplicationFirewallMappings = new ChangeTrackingList<MigrationWebApplicationFirewallMapping>();
        }

        /// <summary> Initializes a new instance of <see cref="MigrationContent"/>. </summary>
        /// <param name="sku"> Sku for the migration. </param>
        /// <param name="classicResourceReference"> Resource reference of the classic cdn profile or classic frontdoor that need to be migrated. </param>
        /// <param name="profileName"> Name of the new profile that need to be created. </param>
        /// <param name="migrationWebApplicationFirewallMappings"> Waf mapping for the migrated profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrationContent(CdnSku sku, WritableSubResource classicResourceReference, string profileName, IList<MigrationWebApplicationFirewallMapping> migrationWebApplicationFirewallMappings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Sku = sku;
            ClassicResourceReference = classicResourceReference;
            ProfileName = profileName;
            MigrationWebApplicationFirewallMappings = migrationWebApplicationFirewallMappings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MigrationContent"/> for deserialization. </summary>
        internal MigrationContent()
        {
        }

        /// <summary> Sku for the migration. </summary>
        internal CdnSku Sku { get; }
        /// <summary> Name of the pricing tier. </summary>
        public CdnSkuName? SkuName
        {
            get => Sku?.Name;
        }

        /// <summary> Resource reference of the classic cdn profile or classic frontdoor that need to be migrated. </summary>
        internal WritableSubResource ClassicResourceReference { get; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier ClassicResourceReferenceId
        {
            get => ClassicResourceReference?.Id;
        }

        /// <summary> Name of the new profile that need to be created. </summary>
        public string ProfileName { get; }
        /// <summary> Waf mapping for the migrated profile. </summary>
        public IList<MigrationWebApplicationFirewallMapping> MigrationWebApplicationFirewallMappings { get; }
    }
}
