// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Result for migrate operation. </summary>
    public partial class MigrateResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrateResult"/>. </summary>
        internal MigrateResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MigrateResult"/>. </summary>
        /// <param name="id"> Resource ID. </param>
        /// <param name="migrateResultType"> Resource type. </param>
        /// <param name="migratedProfileResourceId"> Arm resource id of the migrated profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrateResult(string id, string migrateResultType, WritableSubResource migratedProfileResourceId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            MigrateResultType = migrateResultType;
            MigratedProfileResourceId = migratedProfileResourceId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource ID. </summary>
        public string Id { get; }
        /// <summary> Resource type. </summary>
        public string MigrateResultType { get; }
        /// <summary> Arm resource id of the migrated profile. </summary>
        internal WritableSubResource MigratedProfileResourceId { get; }
        /// <summary> Gets or sets Id. </summary>
        public ResourceIdentifier MigratedProfileResourceIdId
        {
            get => MigratedProfileResourceId?.Id;
        }
    }
}
