// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The MetricsResponseSeriesItemUnit. </summary>
    public readonly partial struct MetricsResponseSeriesItemUnit : IEquatable<MetricsResponseSeriesItemUnit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetricsResponseSeriesItemUnit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetricsResponseSeriesItemUnit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CountValue = "count";
        private const string BytesValue = "bytes";
        private const string BitsPerSecondValue = "bitsPerSecond";
        private const string MilliSecondsValue = "milliSeconds";

        /// <summary> count. </summary>
        public static MetricsResponseSeriesItemUnit Count { get; } = new MetricsResponseSeriesItemUnit(CountValue);
        /// <summary> bytes. </summary>
        public static MetricsResponseSeriesItemUnit Bytes { get; } = new MetricsResponseSeriesItemUnit(BytesValue);
        /// <summary> bitsPerSecond. </summary>
        public static MetricsResponseSeriesItemUnit BitsPerSecond { get; } = new MetricsResponseSeriesItemUnit(BitsPerSecondValue);
        /// <summary> milliSeconds. </summary>
        public static MetricsResponseSeriesItemUnit MilliSeconds { get; } = new MetricsResponseSeriesItemUnit(MilliSecondsValue);
        /// <summary> Determines if two <see cref="MetricsResponseSeriesItemUnit"/> values are the same. </summary>
        public static bool operator ==(MetricsResponseSeriesItemUnit left, MetricsResponseSeriesItemUnit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetricsResponseSeriesItemUnit"/> values are not the same. </summary>
        public static bool operator !=(MetricsResponseSeriesItemUnit left, MetricsResponseSeriesItemUnit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetricsResponseSeriesItemUnit"/>. </summary>
        public static implicit operator MetricsResponseSeriesItemUnit(string value) => new MetricsResponseSeriesItemUnit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetricsResponseSeriesItemUnit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetricsResponseSeriesItemUnit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
