// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The MetricsResponseSeriesItem. </summary>
    public partial class MetricsResponseSeriesItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MetricsResponseSeriesItem"/>. </summary>
        internal MetricsResponseSeriesItem()
        {
            Groups = new ChangeTrackingList<MetricsResponseSeriesPropertiesItemsItem>();
            Data = new ChangeTrackingList<Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems>();
        }

        /// <summary> Initializes a new instance of <see cref="MetricsResponseSeriesItem"/>. </summary>
        /// <param name="metric"></param>
        /// <param name="unit"></param>
        /// <param name="groups"></param>
        /// <param name="data"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MetricsResponseSeriesItem(string metric, MetricsResponseSeriesItemUnit? unit, IReadOnlyList<MetricsResponseSeriesPropertiesItemsItem> groups, IReadOnlyList<Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems> data, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Metric = metric;
            Unit = unit;
            Groups = groups;
            Data = data;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the metric. </summary>
        public string Metric { get; }
        /// <summary> Gets the unit. </summary>
        public MetricsResponseSeriesItemUnit? Unit { get; }
        /// <summary> Gets the groups. </summary>
        public IReadOnlyList<MetricsResponseSeriesPropertiesItemsItem> Groups { get; }
        /// <summary> Gets the data. </summary>
        public IReadOnlyList<Components1Gs0LlpSchemasMetricsresponsePropertiesSeriesItemsPropertiesDataItems> Data { get; }
    }
}
