// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> The MetricsResponseGranularity. </summary>
    public readonly partial struct MetricsResponseGranularity : IEquatable<MetricsResponseGranularity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetricsResponseGranularity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetricsResponseGranularity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PT5MValue = "PT5M";
        private const string PT1HValue = "PT1H";
        private const string P1DValue = "P1D";

        /// <summary> PT5M. </summary>
        public static MetricsResponseGranularity PT5M { get; } = new MetricsResponseGranularity(PT5MValue);
        /// <summary> PT1H. </summary>
        public static MetricsResponseGranularity PT1H { get; } = new MetricsResponseGranularity(PT1HValue);
        /// <summary> P1D. </summary>
        public static MetricsResponseGranularity P1D { get; } = new MetricsResponseGranularity(P1DValue);
        /// <summary> Determines if two <see cref="MetricsResponseGranularity"/> values are the same. </summary>
        public static bool operator ==(MetricsResponseGranularity left, MetricsResponseGranularity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetricsResponseGranularity"/> values are not the same. </summary>
        public static bool operator !=(MetricsResponseGranularity left, MetricsResponseGranularity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetricsResponseGranularity"/>. </summary>
        public static implicit operator MetricsResponseGranularity(string value) => new MetricsResponseGranularity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetricsResponseGranularity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetricsResponseGranularity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
