// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Cdn.Models
{
    /// <summary> Metrics Response. </summary>
    public partial class MetricsResponse
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MetricsResponse"/>. </summary>
        internal MetricsResponse()
        {
            Series = new ChangeTrackingList<MetricsResponseSeriesItem>();
        }

        /// <summary> Initializes a new instance of <see cref="MetricsResponse"/>. </summary>
        /// <param name="dateTimeBegin"></param>
        /// <param name="dateTimeEnd"></param>
        /// <param name="granularity"></param>
        /// <param name="series"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MetricsResponse(DateTimeOffset? dateTimeBegin, DateTimeOffset? dateTimeEnd, MetricsResponseGranularity? granularity, IReadOnlyList<MetricsResponseSeriesItem> series, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DateTimeBegin = dateTimeBegin;
            DateTimeEnd = dateTimeEnd;
            Granularity = granularity;
            Series = series;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the date time begin. </summary>
        public DateTimeOffset? DateTimeBegin { get; }
        /// <summary> Gets the date time end. </summary>
        public DateTimeOffset? DateTimeEnd { get; }
        /// <summary> Gets the granularity. </summary>
        public MetricsResponseGranularity? Granularity { get; }
        /// <summary> Gets the series. </summary>
        public IReadOnlyList<MetricsResponseSeriesItem> Series { get; }
    }
}
